import torch
import random
import numpy as np
import subprocess

device = torch.device('cuda' if torch.cuda.is_available() else 'cpu')
if device.type == 'cuda':
    '''
    Inspired by https://discuss.pytorch.org/t/it-there-anyway-to-let-program-select-free-gpu-automatically/17560/7
    Without using a temp file
    Tested with nvidia-smi 460.67
    '''
    try:
        x=subprocess.check_output('nvidia-smi -q -d Memory |grep -A4 GPU|grep Free', shell=True).decode("UTF-8")
        memory_available = []
        for line in x.split("\n"):
            if line  != '':
                memory_available.append(line.split()[2])
        device_id = int(np.argmax(memory_available))
    except:
        device_id = 0
    torch.cuda.set_device(device_id)

def set_seed(seed=1337):

    np.random.seed(seed)
    random.seed(seed)
    torch.manual_seed(seed)
    torch.cuda.manual_seed_all(seed)